 ; Ŀ
 ;   Above - put text above an attribute or text.                          
 ;   Also Nd - put text below an attribute or text.                        
 ;   Copyright 1995, 1997, 2010 by Rocket Software Ltd.                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Tget - get a string by keyboard entry or entity selection at the      
 ;   same prompt.                                                          
 ;   Takes no arguments, but uses the global variable pstr.                
 ;   Returns a string or nil.                                              
 ;   Calls nothing.                                                        
 ; 
 (DEFUN TGET (/ goon ppstr aa pa)
  (if (= (type pstr) 'STR)
      (prompt (strcat "\nEnter Text or Select an Example (<Return> = "
                       pstr "): "))
      (prompt "\nEnter Text or Select an Example: "))
 ; Ŀ
 ;   Use grread to get points so can also accept keyboard input.           
 ; 
  (setq ppstr "")
  (setq goon t)
  (while (and goon (setq aa (grread () 4 2)))
         (cond ((= (car aa) 3)                             ; a point
                (setq goon ())                             ; leave loop
                (setq pa (cadr aa)))                       ; save point
               ((equal aa (list 2 13))                     ; Keyboard <Return>
                (setq goon ()))                            ; leave looop
               ((equal (car aa) 25)                        ; Mouse <Return>
                (setq goon ()))                            ; leave looop
               ((equal aa (list 6 0))                      ; Digitizer <Return>
                (setq goon ()))                            ; leave looop
               ((equal aa (list 2 2))                      ; F9
                (setvar "snapmode" (abs (1- (getvar "snapmode")))))
               ((equal aa (list 2 15))                     ; F8
                (setvar "orthomode" (abs (1- (getvar "orthomode")))))
               ((equal (car aa) 2)                         ; a keypress
                (setq ppstr (strcat ppstr (setq aa (chr (cadr aa)))))
                (princ aa))))
  (if pa
      (progn
           (if (/= ppstr "") (prompt "\nPoint override."))
           (if (setq ppstr (nentselp pa))
               (if (= (type (caar (reverse ppstr))) 'ENAME)
                   (setq pstr (cdr (assoc 1 (entget (caar (reverse ppstr))))))
                   (setq pstr (cdr (assoc 1 (entget (car ppstr))))))
              (setq pstr ())))
      (if (/= ppstr "") (setq pstr ppstr)))
 pstr)
 ; Ŀ
 ;   Tget end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Sukc - copy an attribute as a text entity.                 
 ; 
 (DEFUN Sukc (entt / bbf nn sublst asonum enam)
  (setq bbf (list (cons 0 "TEXT")))
  (setq nn 0)
  (while (setq sublst (nth nn entt))
         (setq nn (1+ nn))
         (setq asonum (car sublst))
         (cond ((and (= 74 asonum) (= (cdr (assoc 0 entt)) "ATTRIB"))
                (setq bbf (cons (cons 73 (cdr sublst)) bbf)))
               ((and (= 8 asonum) (= (cdr sublst) "0"))
                (setq bbf (cons (cons 8 "TEXT") bbf)))
               ((not (or (= -1 asonum)
                         (= 0 asonum)
                         (= 2 asonum)
                         (= 3 asonum)
                         (= 5 asonum)
                         (= 70 asonum)
                         (= 62 asonum)    ; colour should be bylayer (none)
                         (= 73 asonum)
                         (= 280 asonum))) ; attribute position lock flag
                (setq bbf (cons sublst bbf)))))
 ; Ŀ
 ;   Make the new entity, if this works then return its entity name.       
 ;   If entmake works it returns the data list given to it, not the data   
 ;   list for the new entity, (else nil) so must get the new entity name   
 ;   with (entlast).                                                       
 ; 
  (setq enam (if (entmake (reverse bbf)) (entlast)))
 enam)
 ; Ŀ
 ;   Sukc end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Above: add text above or below text or an attribute.       
 ;   Argument: Dira, up or down, indicates where to put the new text.      
 ;   Calls Sukc and Tget, returns nothing.                                 
 ; 
 (DEFUN ABOVE (dira / snapp *error* enam entt typ incr angg pstr gnustr)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk /)
   (setvar "snapmode" snapp)
   (if enam (redraw enam 4))
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Get a base attribute.                                                 
 ; 
  (setq enam (car (nentsel "Base Attribute: ")))
  (setq entt (entget enam))
 ; Ŀ
 ;   Get an angle and distance to the insertion point for the new text.    
 ; 
  (setq incr (* 1.65 (cdr (assoc 40 entt))))
  (if (= dira "up")
      (setq angg (+ (/ pi 2) (cdr (assoc 50 entt))))
      (setq angg (+ (* pi 1.5) (cdr (assoc 50 entt)))))
 ; Ŀ
 ;   If the entity was an attribute or text then make a new one as text.   
 ; 
  (setq typ (cdr (assoc 0 entt)))
  (if (member typ '("ATTRIB" "TEXT"))
      (setq enam (sukc entt)))
 ; Ŀ
 ;   Reposition the new entity.                                            
 ; 
  (command ".move" enam "" "0,0" (polar '(0 0) angg incr))
 ; Ŀ
 ;   Offer to put a new text string in it.                                 
 ; 
  (setq pstr (cdr (assoc 1 entt)))
  (redraw enam 3)
  (if (setq gnustr (tget))
      (progn
           (setq entt (entget enam))
           (entmod (subst (cons 1 gnustr) (assoc 1 entt) entt)))
      (redraw enam 4))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))
 ; Ŀ
 ;   Subroutine Above end.                                                 
 ; 

 ; Ŀ
 ;   Nd.                                                                   
 ; 
 (DEFUN C:ND ()
  (above "down")
 (princ))

 ; Ŀ
 ;   Above.                                                                
 ; 
 (DEFUN C:ABOVE ()
  (above "up")
 (princ))